/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.ClientController;
import biz.papercut.pcng.client.uit.CustomChoicePrintDialog;
import biz.papercut.pcng.client.uit.CustomHTMLFormPrintDialog;
import biz.papercut.pcng.client.uit.CustomMessagePrintDialog;
import biz.papercut.pcng.client.uit.CustomTextPrintDialog;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientFrame;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.client.dialogrequest.ChoiceDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogRequestWithJobInfo;
import biz.papercut.pcng.common.client.dialogrequest.HTMLFormDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.MessageDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.TextDialogRequest;
import biz.papercut.pcng.util.swing.DialogUtils;
import java.awt.Component;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogRequestHandler
implements ClientController.DialogRequestListener {
    private static final Log logger = LogFactory.getLog(DialogRequestHandler.class);
    private ServerConnection _serverConnection;
    private UserClientConfig _config;
    private UserClientFrame _userClientFrame;

    public DialogRequestHandler(UserClientFrame userClientFrame, ServerConnection serverConnection, UserClientConfig clientConfig) {
        this._serverConnection = serverConnection;
        this._config = clientConfig;
        this._userClientFrame = userClientFrame;
    }

    @Override
    public void newDialogRequests(final List<ClientDialogRequestWithJobInfo> dialogRequests) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    DialogRequestHandler.this.processDialogRequests(dialogRequests);
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)("Unable to process new print jobs: " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDialogRequests(List<ClientDialogRequestWithJobInfo> dialogRequests) {
        try {
            this._userClientFrame.setPopupDialogIsDisplayed(true);
            for (ClientDialogRequestWithJobInfo t : dialogRequests) {
                TextDialogRequest tdr;
                ClientPrintJob job = t.getJob();
                ClientDialogRequest request = t.getRequest();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Dialog request: " + request + ", Job: " + job));
                }
                CustomMessagePrintDialog dialog = null;
                if (request instanceof TextDialogRequest) {
                    tdr = (TextDialogRequest)request;
                    dialog = CustomTextPrintDialog.construct((JFrame)this._userClientFrame, tdr, job, this._serverConnection, this._config);
                } else if (request instanceof ChoiceDialogRequest) {
                    tdr = (ChoiceDialogRequest)request;
                    dialog = CustomChoicePrintDialog.construct((JFrame)this._userClientFrame, (ChoiceDialogRequest)tdr, job, this._serverConnection, this._config);
                } else if (request instanceof HTMLFormDialogRequest) {
                    HTMLFormDialogRequest hfdr = (HTMLFormDialogRequest)request;
                    dialog = CustomHTMLFormPrintDialog.construct(this._userClientFrame, (MessageDialogRequest)hfdr, job, this._serverConnection, this._config);
                } else if (request instanceof MessageDialogRequest) {
                    MessageDialogRequest bdr = (MessageDialogRequest)request;
                    dialog = CustomMessagePrintDialog.construct(this._userClientFrame, bdr, job, this._serverConnection, this._config);
                } else {
                    DialogUtils.showErrorMessageDialog((Component)this._userClientFrame, (String)"Error", (String)("Unsupported dialog type: " + request));
                }
                if (dialog == null) continue;
                dialog.setVisible(true);
                dialog.dispose();
            }
        }
        catch (Throwable t) {
            logger.error((Object)("Error displaying dialog requests. " + t.getMessage()), t);
        }
        finally {
            this._userClientFrame.setPopupDialogIsDisplayed(false);
        }
    }
}

