/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthMenuItemLayoutHelper;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;
import sun.swing.MenuItemLayoutHelper;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthIcon;

public class SynthGraphicsUtils {
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();
    private Rectangle paintViewR = new Rectangle();
    private Insets paintInsets = new Insets(0, 0, 0, 0);
    private Rectangle iconR = new Rectangle();
    private Rectangle textR = new Rectangle();
    private Rectangle viewR = new Rectangle();
    private Insets viewSizingInsets = new Insets(0, 0, 0, 0);

    public void drawLine(SynthContext synthContext, Object object, Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n, n2, n3, n4);
    }

    public void drawLine(SynthContext synthContext, Object object, Graphics graphics, int n, int n2, int n3, int n4, Object object2) {
        if ("dashed".equals(object2)) {
            if (n == n3) {
                n2 += n2 % 2;
                for (int i = n2; i <= n4; i += 2) {
                    graphics.drawLine(n, i, n3, i);
                }
            } else if (n2 == n4) {
                n += n % 2;
                for (int i = n; i <= n3; i += 2) {
                    graphics.drawLine(i, n2, i, n4);
                }
            }
        } else {
            this.drawLine(synthContext, object, graphics, n, n2, n3, n4);
        }
    }

    public String layoutText(SynthContext synthContext, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        if (icon instanceof SynthIcon) {
            SynthIconWrapper synthIconWrapper = SynthIconWrapper.get((SynthIcon)icon, synthContext);
            String string2 = SwingUtilities.layoutCompoundLabel(synthContext.getComponent(), fontMetrics, string, synthIconWrapper, n2, n, n4, n3, rectangle, rectangle2, rectangle3, n5);
            SynthIconWrapper.release(synthIconWrapper);
            return string2;
        }
        return SwingUtilities.layoutCompoundLabel(synthContext.getComponent(), fontMetrics, string, icon, n2, n, n4, n3, rectangle, rectangle2, rectangle3, n5);
    }

    public int computeStringWidth(SynthContext synthContext, Font font, FontMetrics fontMetrics, String string) {
        return SwingUtilities2.stringWidth(synthContext.getComponent(), fontMetrics, string);
    }

    public Dimension getMinimumSize(SynthContext synthContext, Font font, String string, Icon icon, int n, int n2, int n3, int n4, int n5, int n6) {
        JComponent jComponent = synthContext.getComponent();
        Dimension dimension = this.getPreferredSize(synthContext, font, string, icon, n, n2, n3, n4, n5, n6);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getMaximumSize(SynthContext synthContext, Font font, String string, Icon icon, int n, int n2, int n3, int n4, int n5, int n6) {
        JComponent jComponent = synthContext.getComponent();
        Dimension dimension = this.getPreferredSize(synthContext, font, string, icon, n, n2, n3, n4, n5, n6);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    public int getMaximumCharHeight(SynthContext synthContext) {
        FontMetrics fontMetrics = synthContext.getComponent().getFontMetrics(synthContext.getStyle().getFont(synthContext));
        return fontMetrics.getAscent() + fontMetrics.getDescent();
    }

    public Dimension getPreferredSize(SynthContext synthContext, Font font, String string, Icon icon, int n, int n2, int n3, int n4, int n5, int n6) {
        JComponent jComponent = synthContext.getComponent();
        Insets insets = jComponent.getInsets(this.viewSizingInsets);
        int n7 = insets.left + insets.right;
        int n8 = insets.top + insets.bottom;
        if (icon == null && (string == null || font == null)) {
            return new Dimension(n7, n8);
        }
        if (string == null || icon != null && font == null) {
            return new Dimension(SynthIcon.getIconWidth(icon, synthContext) + n7, SynthIcon.getIconHeight(icon, synthContext) + n8);
        }
        FontMetrics fontMetrics = jComponent.getFontMetrics(font);
        this.iconR.height = 0;
        this.iconR.width = 0;
        this.iconR.y = 0;
        this.iconR.x = 0;
        this.textR.height = 0;
        this.textR.width = 0;
        this.textR.y = 0;
        this.textR.x = 0;
        this.viewR.x = n7;
        this.viewR.y = n8;
        this.viewR.height = Short.MAX_VALUE;
        this.viewR.width = Short.MAX_VALUE;
        this.layoutText(synthContext, fontMetrics, string, icon, n, n2, n3, n4, this.viewR, this.iconR, this.textR, n5);
        int n9 = Math.min(this.iconR.x, this.textR.x);
        int n10 = Math.max(this.iconR.x + this.iconR.width, this.textR.x + this.textR.width);
        int n11 = Math.min(this.iconR.y, this.textR.y);
        int n12 = Math.max(this.iconR.y + this.iconR.height, this.textR.y + this.textR.height);
        Dimension dimension = new Dimension(n10 - n9, n12 - n11);
        dimension.width += n7;
        dimension.height += n8;
        return dimension;
    }

    public void paintText(SynthContext synthContext, Graphics graphics, String string, Rectangle rectangle, int n) {
        this.paintText(synthContext, graphics, string, rectangle.x, rectangle.y, n);
    }

    public void paintText(SynthContext synthContext, Graphics graphics, String string, int n, int n2, int n3) {
        if (string != null) {
            JComponent jComponent = synthContext.getComponent();
            SynthStyle synthStyle = synthContext.getStyle();
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics);
            SwingUtilities2.drawString(jComponent, graphics, string, n, n2 += fontMetrics.getAscent());
            if (n3 >= 0 && n3 < string.length()) {
                int n4 = n + SwingUtilities2.stringWidth(jComponent, fontMetrics, string.substring(0, n3));
                int n5 = n2;
                int n6 = fontMetrics.charWidth(string.charAt(n3));
                int n7 = 1;
                graphics.fillRect(n4, n5 + fontMetrics.getDescent() - 1, n6, n7);
            }
        }
    }

    public void paintText(SynthContext synthContext, Graphics graphics, String string, Icon icon, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object;
        if (icon == null && string == null) {
            return;
        }
        JComponent jComponent = synthContext.getComponent();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics);
        Insets insets = SynthLookAndFeel.getPaintingInsets(synthContext, this.paintInsets);
        this.paintViewR.x = insets.left;
        this.paintViewR.y = insets.top;
        this.paintViewR.width = jComponent.getWidth() - (insets.left + insets.right);
        this.paintViewR.height = jComponent.getHeight() - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        String string2 = this.layoutText(synthContext, fontMetrics, string, icon, n, n2, n3, n4, this.paintViewR, this.paintIconR, this.paintTextR, n5);
        if (icon != null) {
            object = graphics.getColor();
            this.paintIconR.x += n7;
            this.paintIconR.y += n7;
            SynthIcon.paintIcon(icon, synthContext, graphics, this.paintIconR.x, this.paintIconR.y, this.paintIconR.width, this.paintIconR.height);
            graphics.setColor((Color)object);
        }
        if (string != null) {
            object = (View)jComponent.getClientProperty("html");
            if (object != null) {
                ((View)object).paint(graphics, this.paintTextR);
            } else {
                this.paintTextR.x += n7;
                this.paintTextR.y += n7;
                this.paintText(synthContext, graphics, string2, this.paintTextR, n6);
            }
        }
    }

    static Dimension getPreferredMenuItemSize(SynthContext synthContext, SynthContext synthContext2, JComponent jComponent, Icon icon, Icon icon2, int n, String string, boolean bl, String string2) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        SynthMenuItemLayoutHelper synthMenuItemLayoutHelper = new SynthMenuItemLayoutHelper(synthContext, synthContext2, jMenuItem, icon, icon2, MenuItemLayoutHelper.createMaxRect(), n, string, SynthLookAndFeel.isLeftToRight(jMenuItem), bl, string2);
        Dimension dimension = new Dimension();
        int n2 = synthMenuItemLayoutHelper.getGap();
        dimension.width = 0;
        MenuItemLayoutHelper.addMaxWidth(synthMenuItemLayoutHelper.getCheckSize(), n2, dimension);
        MenuItemLayoutHelper.addMaxWidth(synthMenuItemLayoutHelper.getLabelSize(), n2, dimension);
        MenuItemLayoutHelper.addWidth(synthMenuItemLayoutHelper.getMaxAccOrArrowWidth(), 5 * n2, dimension);
        dimension.width -= n2;
        dimension.height = MenuItemLayoutHelper.max(synthMenuItemLayoutHelper.getCheckSize().getHeight(), synthMenuItemLayoutHelper.getLabelSize().getHeight(), synthMenuItemLayoutHelper.getAccSize().getHeight(), synthMenuItemLayoutHelper.getArrowSize().getHeight());
        Insets insets = synthMenuItemLayoutHelper.getMenuItem().getInsets();
        if (insets != null) {
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
        }
        if (dimension.width % 2 == 0) {
            ++dimension.width;
        }
        if (dimension.height % 2 == 0) {
            ++dimension.height;
        }
        return dimension;
    }

    static void applyInsets(Rectangle rectangle, Insets insets) {
        if (insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.right + rectangle.x;
            rectangle.height -= insets.bottom + rectangle.y;
        }
    }

    static void paint(SynthContext synthContext, SynthContext synthContext2, Graphics graphics, Icon icon, Icon icon2, String string, int n, String string2) {
        JMenuItem jMenuItem = (JMenuItem)synthContext.getComponent();
        SynthStyle synthStyle = synthContext.getStyle();
        graphics.setFont(synthStyle.getFont(synthContext));
        Rectangle rectangle = new Rectangle(0, 0, jMenuItem.getWidth(), jMenuItem.getHeight());
        SynthGraphicsUtils.applyInsets(rectangle, jMenuItem.getInsets());
        SynthMenuItemLayoutHelper synthMenuItemLayoutHelper = new SynthMenuItemLayoutHelper(synthContext, synthContext2, jMenuItem, icon, icon2, rectangle, n, string, SynthLookAndFeel.isLeftToRight(jMenuItem), MenuItemLayoutHelper.useCheckAndArrow(jMenuItem), string2);
        MenuItemLayoutHelper.LayoutResult layoutResult = synthMenuItemLayoutHelper.layoutMenuItem();
        SynthGraphicsUtils.paintMenuItem(graphics, synthMenuItemLayoutHelper, layoutResult);
    }

    static void paintMenuItem(Graphics graphics, SynthMenuItemLayoutHelper synthMenuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult) {
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        SynthGraphicsUtils.paintBackground(graphics, synthMenuItemLayoutHelper);
        SynthGraphicsUtils.paintCheckIcon(graphics, synthMenuItemLayoutHelper, layoutResult);
        SynthGraphicsUtils.paintIcon(graphics, synthMenuItemLayoutHelper, layoutResult);
        SynthGraphicsUtils.paintText(graphics, synthMenuItemLayoutHelper, layoutResult);
        SynthGraphicsUtils.paintAccText(graphics, synthMenuItemLayoutHelper, layoutResult);
        SynthGraphicsUtils.paintArrowIcon(graphics, synthMenuItemLayoutHelper, layoutResult);
        graphics.setColor(color);
        graphics.setFont(font);
    }

    static void paintBackground(Graphics graphics, SynthMenuItemLayoutHelper synthMenuItemLayoutHelper) {
        SynthGraphicsUtils.paintBackground(synthMenuItemLayoutHelper.getContext(), graphics, synthMenuItemLayoutHelper.getMenuItem());
    }

    static void paintBackground(SynthContext synthContext, Graphics graphics, JComponent jComponent) {
        synthContext.getPainter().paintMenuItemBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    static void paintIcon(Graphics graphics, SynthMenuItemLayoutHelper synthMenuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult) {
        if (synthMenuItemLayoutHelper.getIcon() != null) {
            Icon icon;
            JMenuItem jMenuItem = synthMenuItemLayoutHelper.getMenuItem();
            ButtonModel buttonModel = jMenuItem.getModel();
            if (!buttonModel.isEnabled()) {
                icon = jMenuItem.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = jMenuItem.getPressedIcon();
                if (icon == null) {
                    icon = jMenuItem.getIcon();
                }
            } else {
                icon = jMenuItem.getIcon();
            }
            if (icon != null) {
                Rectangle rectangle = layoutResult.getIconRect();
                SynthIcon.paintIcon(icon, synthMenuItemLayoutHelper.getContext(), graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    static void paintCheckIcon(Graphics graphics, SynthMenuItemLayoutHelper synthMenuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult) {
        if (synthMenuItemLayoutHelper.getCheckIcon() != null) {
            Rectangle rectangle = layoutResult.getCheckRect();
            SynthIcon.paintIcon(synthMenuItemLayoutHelper.getCheckIcon(), synthMenuItemLayoutHelper.getContext(), graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    static void paintAccText(Graphics graphics, SynthMenuItemLayoutHelper synthMenuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult) {
        String string = synthMenuItemLayoutHelper.getAccText();
        if (string != null && !string.equals("")) {
            graphics.setColor(synthMenuItemLayoutHelper.getAccStyle().getColor(synthMenuItemLayoutHelper.getAccContext(), ColorType.TEXT_FOREGROUND));
            graphics.setFont(synthMenuItemLayoutHelper.getAccStyle().getFont(synthMenuItemLayoutHelper.getAccContext()));
            synthMenuItemLayoutHelper.getAccGraphicsUtils().paintText(synthMenuItemLayoutHelper.getAccContext(), graphics, string, layoutResult.getAccRect().x, layoutResult.getAccRect().y, -1);
        }
    }

    static void paintText(Graphics graphics, SynthMenuItemLayoutHelper synthMenuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult) {
        if (!synthMenuItemLayoutHelper.getText().equals("")) {
            if (synthMenuItemLayoutHelper.getHtmlView() != null) {
                synthMenuItemLayoutHelper.getHtmlView().paint(graphics, layoutResult.getTextRect());
            } else {
                graphics.setColor(synthMenuItemLayoutHelper.getStyle().getColor(synthMenuItemLayoutHelper.getContext(), ColorType.TEXT_FOREGROUND));
                graphics.setFont(synthMenuItemLayoutHelper.getStyle().getFont(synthMenuItemLayoutHelper.getContext()));
                synthMenuItemLayoutHelper.getGraphicsUtils().paintText(synthMenuItemLayoutHelper.getContext(), graphics, synthMenuItemLayoutHelper.getText(), layoutResult.getTextRect().x, layoutResult.getTextRect().y, synthMenuItemLayoutHelper.getMenuItem().getDisplayedMnemonicIndex());
            }
        }
    }

    static void paintArrowIcon(Graphics graphics, SynthMenuItemLayoutHelper synthMenuItemLayoutHelper, MenuItemLayoutHelper.LayoutResult layoutResult) {
        if (synthMenuItemLayoutHelper.getArrowIcon() != null) {
            Rectangle rectangle = layoutResult.getArrowRect();
            SynthIcon.paintIcon(synthMenuItemLayoutHelper.getArrowIcon(), synthMenuItemLayoutHelper.getContext(), graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private static class SynthIconWrapper
    implements Icon {
        private static final List CACHE = new ArrayList(1);
        private SynthIcon synthIcon;
        private SynthContext context;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static SynthIconWrapper get(SynthIcon synthIcon, SynthContext synthContext) {
            List list = CACHE;
            synchronized (list) {
                int n = CACHE.size();
                if (n > 0) {
                    SynthIconWrapper synthIconWrapper = (SynthIconWrapper)CACHE.remove(n - 1);
                    synthIconWrapper.reset(synthIcon, synthContext);
                    return synthIconWrapper;
                }
            }
            return new SynthIconWrapper(synthIcon, synthContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void release(SynthIconWrapper synthIconWrapper) {
            synthIconWrapper.reset(null, null);
            List list = CACHE;
            synchronized (list) {
                CACHE.add(synthIconWrapper);
            }
        }

        SynthIconWrapper(SynthIcon synthIcon, SynthContext synthContext) {
            this.reset(synthIcon, synthContext);
        }

        void reset(SynthIcon synthIcon, SynthContext synthContext) {
            this.synthIcon = synthIcon;
            this.context = synthContext;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return this.synthIcon.getIconWidth(this.context);
        }

        public int getIconHeight() {
            return this.synthIcon.getIconHeight(this.context);
        }
    }
}

