/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class PlatformInfo {
    private final String _osName;
    private final String _osVersion;
    private final String _osPatchLevel;
    private final String _osArch;
    private final String _jvmVersion;
    private final String _jvmArch;

    public static PlatformInfo getPlatformInfo() {
        String jvmArch;
        String osName = StringUtils.trimToEmpty((String)System.getProperty("os.name"));
        String osVersion = StringUtils.trimToEmpty((String)System.getProperty("os.version"));
        String osPatchLevel = StringUtils.trimToEmpty((String)System.getProperty("sun.os.patch.level"));
        String osArch = jvmArch = StringUtils.trimToEmpty((String)System.getProperty("os.arch")).toLowerCase();
        String jvmVersion = StringUtils.trimToEmpty((String)System.getProperty("java.runtime.version"));
        if (SystemUtils.IS_OS_WINDOWS) {
            String procArch = StringUtils.trimToEmpty((String)System.getenv("PROCESSOR_ARCHITECTURE")).toLowerCase();
            String procWOWArch = StringUtils.trimToEmpty((String)System.getenv("PROCESSOR_ARCHITEW6432")).toLowerCase();
            if (jvmArch.equals("amd64") || procArch.equals("amd64") || procWOWArch.equals("amd64")) {
                osArch = "amd64";
            }
        }
        return new PlatformInfo(osName, osVersion, osPatchLevel, osArch, jvmVersion, jvmArch);
    }

    private PlatformInfo(String osName, String osVersion, String osPatchLevel, String osArch, String jvmVersion, String jvmArch) {
        this._osName = osName;
        this._osVersion = osVersion;
        this._osPatchLevel = osPatchLevel;
        this._osArch = osArch;
        this._jvmVersion = jvmVersion;
        this._jvmArch = jvmArch;
    }

    public String getOSName() {
        return this._osName;
    }

    public String getOSVersion() {
        return this._osVersion;
    }

    public String getOSPatchLevel() {
        return this._osPatchLevel;
    }

    public String getOSArch() {
        return this._osArch;
    }

    public boolean isOS64Bit() {
        return this._osArch.equalsIgnoreCase("amd64");
    }

    public String getJVMVersion() {
        return this._jvmVersion;
    }

    public String getJVMArch() {
        return this._jvmArch;
    }

    public boolean isJVM64Bit() {
        return this._jvmArch.equalsIgnoreCase("amd64");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._osName);
        sb.append(" - ");
        sb.append(this._osVersion);
        if (StringUtils.isNotBlank((String)this._osPatchLevel)) {
            sb.append(" (").append(this._osPatchLevel).append(")");
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            sb.append(" ");
            sb.append(this.isOS64Bit() ? "64-bit" : "32-bit");
        }
        sb.append(" [runtime: ");
        sb.append(this._jvmVersion);
        sb.append(" (");
        sb.append(this._jvmArch);
        sb.append(")]");
        return sb.toString();
    }
}

