/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.common;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class WindowsMenuItemCommonUI {
    void paintBackground(Graphics g, JMenuItem item, Color bgColor, boolean mouseOver) {
        ButtonModel model = item.getModel();
        Color oldColor = g.getColor();
        if (item.isOpaque()) {
            if (item.isArmed() || item instanceof JMenu && model.isSelected() || !model.isEnabled() && mouseOver) {
                g.setColor(bgColor);
            } else {
                g.setColor(item.getBackground());
            }
        }
        g.fillRect(0, 0, item.getWidth(), item.getHeight());
        g.setColor(oldColor);
    }

    void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text, Color selectionForeground, String propertyPrefix) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fontMetrics = g.getFontMetrics();
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (WindowsLookAndFeel.isMnemonicHidden()) {
            mnemIndex = -1;
        }
        if (!model.isEnabled()) {
            g.setColor(UIManager.getColor(propertyPrefix + ".disabledForeground"));
        } else if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            g.setColor(selectionForeground);
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fontMetrics.getAscent());
    }
}

