/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.AdvancedAccountDialog;
import biz.papercut.pcng.client.uit.ClientController;
import biz.papercut.pcng.client.uit.ManagerModeDialog;
import biz.papercut.pcng.client.uit.SelectAccountDialog;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientFrame;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.ClientPrintPopupConfig;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientPrintJobHandler
implements ClientController.PrintJobListener {
    private static final Log logger = LogFactory.getLog(ClientPrintJobHandler.class);
    private ServerConnection _serverConnection;
    private UserClientConfig _config;
    private UserClientFrame _userClientFrame;

    public ClientPrintJobHandler(UserClientFrame userClientFrame, ServerConnection serverConnection, UserClientConfig clientConfig) {
        this._serverConnection = serverConnection;
        this._config = clientConfig;
        this._userClientFrame = userClientFrame;
    }

    @Override
    public void newPrintJobs(final List<ClientPrintJob> printJobs) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ClientPrintJobHandler.this.processPrintJobs(printJobs);
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)("Unable to process new print jobs: " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPrintJobs(List<ClientPrintJob> printJobs) {
        try {
            this._userClientFrame.setPopupDialogIsDisplayed(true);
            for (ClientPrintJob job : printJobs) {
                ClientPrintPopupConfig printJobConfig;
                try {
                    printJobConfig = this._serverConnection.getPrintJobPopupConfig(job);
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to fetch print job config. Using defaults. " + e.getMessage()), (Throwable)e);
                    printJobConfig = new ClientPrintPopupConfig();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Displaying print popup for job: " + job + " Popup config:" + printJobConfig));
                }
                boolean appliedToAllJobs = false;
                switch (printJobConfig.getPopupType()) {
                    case Advanced: {
                        JDialog d = new AdvancedAccountDialog(this._userClientFrame, this._config, this._serverConnection, job, printJobConfig);
                        d.setVisible(true);
                        appliedToAllJobs = ((AdvancedAccountDialog)d).selectionAppliedToAllJobs();
                        d.dispose();
                        d = null;
                        break;
                    }
                    case Manager: {
                        JDialog d = new ManagerModeDialog(this._userClientFrame, this._config, this._serverConnection, job);
                        d.setVisible(true);
                        appliedToAllJobs = ((ManagerModeDialog)d).selectionAppliedToAllJobs();
                        d.dispose();
                        d = null;
                        break;
                    }
                    case Standard: 
                    case Confirmation: {
                        JDialog d = new SelectAccountDialog(this._userClientFrame, this._config, this._serverConnection, job, printJobConfig);
                        d.setVisible(true);
                        appliedToAllJobs = ((SelectAccountDialog)d).selectionAppliedToAllJobs();
                        d.dispose();
                        d = null;
                        break;
                    }
                }
                if (!appliedToAllJobs) continue;
                logger.debug((Object)"Selection was applied to all, don't process any more events.");
                break;
            }
        }
        catch (Throwable t) {
            logger.error((Object)("Error displaying SelectAccountDialog. " + t.getMessage()), t);
        }
        finally {
            this._userClientFrame.setPopupDialogIsDisplayed(false);
        }
    }
}

