/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.PathIterator;
import java.util.NoSuchElementException;

class CubicIterator
implements PathIterator {
    CubicCurve2D cubic;
    AffineTransform affine;
    int index;

    CubicIterator(CubicCurve2D cubicCurve2D, AffineTransform affineTransform) {
        this.cubic = cubicCurve2D;
        this.affine = affineTransform;
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.index > 1;
    }

    public void next() {
        ++this.index;
    }

    public int currentSegment(float[] fArray) {
        int n;
        if (this.isDone()) {
            throw new NoSuchElementException("cubic iterator iterator out of bounds");
        }
        if (this.index == 0) {
            fArray[0] = (float)this.cubic.getX1();
            fArray[1] = (float)this.cubic.getY1();
            n = 0;
        } else {
            fArray[0] = (float)this.cubic.getCtrlX1();
            fArray[1] = (float)this.cubic.getCtrlY1();
            fArray[2] = (float)this.cubic.getCtrlX2();
            fArray[3] = (float)this.cubic.getCtrlY2();
            fArray[4] = (float)this.cubic.getX2();
            fArray[5] = (float)this.cubic.getY2();
            n = 3;
        }
        if (this.affine != null) {
            this.affine.transform(fArray, 0, fArray, 0, this.index == 0 ? 1 : 3);
        }
        return n;
    }

    public int currentSegment(double[] dArray) {
        int n;
        if (this.isDone()) {
            throw new NoSuchElementException("cubic iterator iterator out of bounds");
        }
        if (this.index == 0) {
            dArray[0] = this.cubic.getX1();
            dArray[1] = this.cubic.getY1();
            n = 0;
        } else {
            dArray[0] = this.cubic.getCtrlX1();
            dArray[1] = this.cubic.getCtrlY1();
            dArray[2] = this.cubic.getCtrlX2();
            dArray[3] = this.cubic.getCtrlY2();
            dArray[4] = this.cubic.getX2();
            dArray[5] = this.cubic.getY2();
            n = 3;
        }
        if (this.affine != null) {
            this.affine.transform(dArray, 0, dArray, 0, this.index == 0 ? 1 : 3);
        }
        return n;
    }
}

