/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.GlobConverter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobStringList {
    private static final Log logger = LogFactory.getLog(GlobStringList.class);
    private Set<String> _regexStrings = new HashSet<String>(100);
    private List<Pattern> _patterns = new ArrayList<Pattern>(100);

    public GlobStringList() {
    }

    public GlobStringList(List<String> globStrings) {
        this.add(globStrings);
    }

    public void add(List<String> globStrings) {
        for (String globString : globStrings) {
            this.add(globString);
        }
    }

    public static String convertGlobToRegex(String globString) {
        return GlobConverter.globToRegExp(globString);
    }

    public void add(String globString) {
        this.addRegex(GlobStringList.convertGlobToRegex(globString));
    }

    public void addRegex(String reString) {
        if (this._regexStrings.add(reString)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding regex: " + reString));
            }
            Pattern p = Pattern.compile(reString, 2);
            this._patterns.add(p);
        }
    }

    public void clear() {
        this._regexStrings.clear();
        this._patterns.clear();
    }

    public boolean matchesAny(String str) {
        if (this._patterns.size() == 0) {
            return false;
        }
        if (str == null || str.length() == 0) {
            return false;
        }
        for (Pattern pattern : this._patterns) {
            if (!pattern.matcher(str).matches()) continue;
            return true;
        }
        return false;
    }
}

