/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class LinkLabel
extends JLabel {
    private Color _highlightedColor = Color.BLUE;
    private String _linkText = null;
    private boolean _alwaysShowUnderline = false;
    private Color _savedForegroundColor = null;
    private ActionListener _actionListener;

    public LinkLabel() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                LinkLabel.this.highlightLink();
            }

            public void mouseReleased(MouseEvent evt) {
                if (LinkLabel.this._actionListener != null) {
                    ActionEvent action = new ActionEvent(evt.getSource(), 1001, "clicked", evt.getModifiers());
                    LinkLabel.this._actionListener.actionPerformed(action);
                }
            }

            public void mouseEntered(MouseEvent evt) {
                LinkLabel.this.highlightLink();
            }

            public void mouseExited(MouseEvent evt) {
                LinkLabel.this.unhighlightLink();
            }
        });
    }

    public void unhighlightLink() {
        if (this._savedForegroundColor != null) {
            this.setForeground(this._savedForegroundColor);
            this._savedForegroundColor = null;
        }
        LinkLabel.super.setText(this.buildLinkHTMLText(false));
    }

    public void highlightLink() {
        if (this._savedForegroundColor == null) {
            this._savedForegroundColor = this.getForeground();
            this.setForeground(this.getHighlightedColor());
        }
        LinkLabel.super.setText(this.buildLinkHTMLText(true));
    }

    private String buildLinkHTMLText(boolean hovered) {
        if (hovered || this._alwaysShowUnderline) {
            return "<html><u>" + this._linkText + "</u></html>";
        }
        return "<html>" + this._linkText + "</html>";
    }

    public LinkLabel(String text) {
        this();
        this.setText(text);
    }

    public void setActionListener(ActionListener listener) {
        this._actionListener = listener;
    }

    public void setText(String text) {
        this._linkText = text;
        super.setText(this.buildLinkHTMLText(false));
    }

    public Color getHighlightedColor() {
        return this._highlightedColor;
    }

    public void setHighlightedColor(Color highlightedColor) {
        this._highlightedColor = highlightedColor;
    }

    public boolean isAlwaysShowUnderline() {
        return this._alwaysShowUnderline;
    }

    public void setAlwaysShowUnderline(boolean alwaysShowUnderline) {
        this._alwaysShowUnderline = alwaysShowUnderline;
    }
}

