/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing;

import biz.papercut.pcng.util.ApplicationInfo;
import biz.papercut.pcng.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DialogUtils {
    private static final Log logger = LogFactory.getLog(DialogUtils.class);
    private static Method CODE_POINT_AT_METHOD = null;
    private static Method SET_ALWAYS_ON_TOP_METHOD = null;

    private DialogUtils() {
    }

    public static void showInformationMessageDialog(Component parentComponent, String title, String message) {
        logger.debug((Object)("Show info msg: " + message));
        JOptionPane pane = new JOptionPane(message, 1);
        JDialog frame = pane.createDialog(parentComponent, DialogUtils.prefixAppName(title));
        DialogUtils.centreFrame(frame);
        frame.setVisible(true);
        logger.debug((Object)"completed show message");
    }

    public static void showWarningMessageDialog(Component parentComponent, String title, String message) {
        logger.debug((Object)("Show warn msg: " + message));
        JOptionPane pane = new JOptionPane(message, 2);
        JDialog frame = pane.createDialog(parentComponent, DialogUtils.prefixAppName(title));
        DialogUtils.centreFrame(frame);
        frame.setVisible(true);
        logger.debug((Object)"completed show message");
    }

    public static void showErrorMessageDialog(Component parentComponent, String title, String message) {
        logger.debug((Object)("Show error msg: " + message));
        JOptionPane pane = new JOptionPane(message, 0);
        JDialog frame = pane.createDialog(parentComponent, DialogUtils.prefixAppName(title));
        DialogUtils.centreFrame(frame);
        DialogUtils.setAlwaysOnTop(frame, true);
        frame.setVisible(true);
        logger.debug((Object)"completed show message");
    }

    private static String prefixAppName(String title) {
        try {
            String appName = ApplicationInfo.getInstance().getApplicationName();
            if (StringUtils.isBlank((String)title)) {
                return appName;
            }
            return appName + " - " + title;
        }
        catch (Exception exception) {
            return title;
        }
    }

    public static int showYesNoDialog(Component parent, String title, String message) {
        JOptionPane pane = new JOptionPane(message, 2, 0);
        JDialog frame = pane.createDialog(parent, title);
        DialogUtils.centreFrame(frame);
        frame.setVisible(true);
        return DialogUtils.getOptionPaneReturnValue(pane);
    }

    private static int getOptionPaneReturnValue(JOptionPane pane) {
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        Object[] options = pane.getOptions();
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    public static void centreFrame(Window frame) {
        frame.setLocationRelativeTo(null);
    }

    public static void setTextHandlingFontDisplayProblems(JLabel label, String text) {
        Font currentFont = label.getFont();
        if (!currentFont.getName().equalsIgnoreCase("SanSerif") && (DialogUtils.containsNonLatinChars(text) || SwingUtils.isLocaleThatHasFontDisplayProblems())) {
            logger.debug((Object)"Problem Font detected. Setting to SanSerif");
            label.setFont(new Font("SanSerif", currentFont.getStyle(), currentFont.getSize()));
        }
        label.setText(text);
    }

    public static boolean containsNonLatinChars(String s) {
        for (int i = 0; i < s.length(); ++i) {
            int codePoint = DialogUtils.getCodePointAt(s, i);
            if (codePoint < 0) {
                return true;
            }
            if (codePoint <= 255 || codePoint == 8364) continue;
            return true;
        }
        return false;
    }

    private static int getCodePointAt(String s, int i) {
        int codePoint = -1;
        try {
            if (CODE_POINT_AT_METHOD == null) {
                CODE_POINT_AT_METHOD = String.class.getMethod("codePointAt", Integer.TYPE);
            }
            Integer codePointObj = (Integer)CODE_POINT_AT_METHOD.invoke((Object)s, i);
            codePoint = codePointObj;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return codePoint;
    }

    public static void setAlwaysOnTop(Window window, boolean alwaysOnTop) {
        block3: {
            try {
                if (SET_ALWAYS_ON_TOP_METHOD == null) {
                    SET_ALWAYS_ON_TOP_METHOD = Window.class.getMethod("setAlwaysOnTop", Boolean.TYPE);
                }
                SET_ALWAYS_ON_TOP_METHOD.invoke((Object)window, alwaysOnTop);
            }
            catch (Exception e) {
                if (!alwaysOnTop) break block3;
                window.toFront();
            }
        }
    }

    public static boolean hasSetAlwaysOnTop() {
        try {
            if (SET_ALWAYS_ON_TOP_METHOD == null) {
                SET_ALWAYS_ON_TOP_METHOD = Window.class.getMethod("setAlwaysOnTop", Boolean.TYPE);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void forceRepaintAfterOpened(final Window window) {
        window.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                String windowId = window.getClass().getSimpleName();
                long delay = 500L;
                logger.debug((Object)(windowId + " opened, force repaint in " + 500L + "ms"));
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        logger.debug((Object)"Force repaint");
                        window.setSize(window.getWidth() + 1, window.getHeight());
                    }
                }, "force-repaint-" + windowId);
                t.setDaemon(true);
                t.start();
            }
        });
    }
}

