/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common.client.dialogrequest;

import biz.papercut.pcng.common.client.dialogrequest.ClientDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogResponse;
import biz.papercut.pcng.common.client.dialogrequest.MessageDialogResponse;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDialogRequest
extends ClientDialogRequest {
    static final String TYPE_NAME = "MessageDialog";
    public static final String ARG_MESSAGE = "message";
    public static final String ARG_BUTTONS = "buttons";
    public static final String BUTTON_OK = "OK";
    public static final String BUTTON_CANCEL = "CANCEL";
    public static final String BUTTON_YES = "YES";
    public static final String BUTTON_NO = "NO";

    public MessageDialogRequest(String uniqueID, Map<String, Object> optionalArgs, String message, String ... buttons) {
        super(uniqueID, optionalArgs);
        message = StringUtils.trimToEmpty((String)message);
        this._data.put(ARG_MESSAGE, message);
        Vector<String> buttonsVector = new Vector<String>(buttons.length);
        for (String button : buttons) {
            buttonsVector.add(button);
        }
        this._data.put(ARG_BUTTONS, buttonsVector);
        this.loadOptionalArgs(optionalArgs);
    }

    public MessageDialogRequest(Hashtable<String, Object> data) {
        super(data);
        String message = StringUtils.trimToEmpty((String)((String)data.get(ARG_MESSAGE)));
        this._data.put(ARG_MESSAGE, message);
        Vector v = (Vector)data.get(ARG_BUTTONS);
        if (v == null) {
            v = new Vector(0);
        }
        this._data.put(ARG_BUTTONS, v);
        this.loadOptionalArgs(data);
    }

    @Override
    protected Set<String> getSupportedArgNames() {
        Set<String> r = super.getSupportedArgNames();
        r.add(ARG_MESSAGE);
        r.add(ARG_BUTTONS);
        return r;
    }

    private void loadOptionalArgs(Map<String, Object> optionalArgs) {
    }

    @Override
    public String getDialogTypeName() {
        return TYPE_NAME;
    }

    @Override
    public ClientDialogResponse parseResponse(Hashtable<String, Object> data) {
        return new MessageDialogResponse(data);
    }

    public final String getMessage() {
        return (String)this._data.get(ARG_MESSAGE);
    }

    public final Vector<String> getButtons() {
        return (Vector)this._data.get(ARG_BUTTONS);
    }
}

