/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit.accounts;

import biz.papercut.pcng.util.NumberUtils;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class AccountIdListModel {
    private EventListenerList _listenerList = new EventListenerList();
    private ChangeEvent _changeEvent = null;
    private List<Long> _accountIds;

    public AccountIdListModel(String accounts) {
        this._accountIds = NumberUtils.splitStringToLongList((String)accounts, (char)',');
    }

    public Long get(int index) {
        return this._accountIds.get(index);
    }

    public int size() {
        return this._accountIds.size();
    }

    public void add(Long l) {
        this._accountIds.add(l);
        this.fireChangeEvent();
    }

    public void remove(Long l) {
        this._accountIds.remove(l);
        this.fireChangeEvent();
    }

    public boolean contains(Long l) {
        return this._accountIds.contains(l);
    }

    public void swap(Long a, Long b) {
        int aindex = this._accountIds.indexOf(a);
        int bindex = this._accountIds.indexOf(b);
        if (aindex < 0 || bindex < 0) {
            return;
        }
        Long tmp = this._accountIds.get(aindex);
        this._accountIds.set(aindex, this._accountIds.get(bindex));
        this._accountIds.set(bindex, tmp);
        this.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener l) {
        this._listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._listenerList.remove(ChangeListener.class, l);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this._accountIds.size(); ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(this._accountIds.get(i).toString());
        }
        return buf.toString();
    }

    private void fireChangeEvent() {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this._changeEvent == null) {
                this._changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this._changeEvent);
        }
    }
}

