/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Messages {
    private static final Log logger = LogFactory.getLog(Messages.class);
    private static final String MESSAGE_FILE_NAME = "messages";
    private static final Locale NO_LANGUAGE_HACK_LOCALE = new Locale("");

    private Messages() {
    }

    public static ResourceBundle loadBundle(Class<? extends Object> clazz, Locale locale) {
        String bundleName = clazz.getPackage().getName() + "." + MESSAGE_FILE_NAME;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ("en".equalsIgnoreCase(locale.getLanguage())) {
            locale = NO_LANGUAGE_HACK_LOCALE;
        }
        return ResourceBundle.getBundle(bundleName, locale, clazz.getClassLoader());
    }

    public static String getString(Class<? extends Object> clazz, @Nullable Locale locale, String key, String ... args) {
        try {
            String pattern = Messages.loadStringFromBundle(clazz, locale, key);
            if (args == null || args.length == 0) {
                return pattern;
            }
            try {
                return MessageFormat.format(pattern, args);
            }
            catch (IllegalArgumentException iae) {
                logger.error((Object)("Error parsing message: " + pattern + " Locale: " + locale + " Err: " + iae.getMessage()));
                return Messages.formatUnknownString(key);
            }
        }
        catch (MissingResourceException e) {
            return Messages.formatUnknownString(key);
        }
    }

    public static String getHtmlString(Class<? extends Object> clazz, Locale locale, String key, String ... args) {
        return StringEscapeUtils.escapeHtml((String)Messages.getString(clazz, locale, key, args));
    }

    public static String getXmlString(Class<? extends Object> clazz, Locale locale, String key, String ... args) {
        return StringEscapeUtils.escapeXml((String)Messages.getString(clazz, locale, key, args));
    }

    public static String getString(Class<? extends Object> clazz, String key, String ... args) {
        return Messages.getString(clazz, null, key, args);
    }

    private static String loadStringFromBundle(Class<? extends Object> clazz, Locale locale, String key) {
        return Messages.loadBundle(clazz, locale).getString(key);
    }

    private static String formatUnknownString(String key) {
        return "!" + key + "!";
    }
}

