/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.UserClient;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.util.Formatter;
import biz.papercut.pcng.util.Messages;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class PrintJobDetailsPanel
extends JPanel {
    private JLabel _documentNameLabel = null;
    private JLabel _printerLabel = null;
    private JLabel _pagesLabel = null;
    private JLabel _costLabel = null;
    private JTextField _totalPagesTextField = null;
    private JTextField _costTextField = null;
    private JTextField _docNameTextField = null;
    private JTextField _printerNameTextField = null;

    public PrintJobDetailsPanel() {
        this.constructGUI();
        this.localizeStrings();
    }

    public void displayJobDetails(ClientPrintJob job) {
        this.setDocumentName(job.getDocumentName());
        this.setPrinterName(job.getServerName() + "\\" + job.getPrinterName());
        if (job.isPreNotification()) {
            if (this.getCost().length() <= 0) {
                String waitText = "...";
                this.setCost(waitText);
                this.setTotalPages(waitText);
            } else {
                String waitText = this.getCost() + ".";
                this.setCost(waitText);
                this.setTotalPages(waitText);
            }
        } else {
            this.setCost(job.getFormattedCost());
            this.setTotalPages(PrintJobDetailsPanel.formatPagesText(job.getTotalPages(), job.getColorPages()));
        }
    }

    public void setDocumentName(String docName) {
        this._docNameTextField.setText(docName);
    }

    public void setTotalPages(String totalPages) {
        this._totalPagesTextField.setText(totalPages);
    }

    public void setCost(String cost) {
        this._costTextField.setText(cost);
    }

    public String getCost() {
        return this._costTextField.getText();
    }

    public void setPrinterName(String printerName) {
        this._printerNameTextField.setText(printerName);
    }

    private void localizeStrings() {
        ((TitledBorder)this.getBorder()).setTitle(PrintJobDetailsPanel.getMessage("print-details", new String[0]));
        this._documentNameLabel.setText(PrintJobDetailsPanel.getMessage("document-name", new String[0]));
        this._printerLabel.setText(PrintJobDetailsPanel.getMessage("printer-name", new String[0]));
        this._costLabel.setText(PrintJobDetailsPanel.getMessage("cost", new String[0]));
        this._pagesLabel.setText(PrintJobDetailsPanel.getMessage("pages", new String[0]));
    }

    public static String formatPagesText(int totalPages, int colorPages) {
        StringBuilder pagesText = new StringBuilder();
        pagesText.append(Formatter.formatInteger((int)totalPages, null));
        String SPACING = "   ";
        if (colorPages > 0) {
            pagesText.append("   " + PrintJobDetailsPanel.getMessage("color-pages", Formatter.formatInteger((int)colorPages, null)));
        } else if (colorPages == 0) {
            pagesText.append("   " + PrintJobDetailsPanel.getMessage("grayscale", Formatter.formatInteger((int)colorPages, null)));
        }
        return pagesText.toString();
    }

    private void constructGUI() {
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.fill = 2;
        gridBagConstraints13.gridy = 2;
        gridBagConstraints13.weightx = 1.0;
        gridBagConstraints13.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints13.gridx = 3;
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.gridy = 2;
        gridBagConstraints12.weightx = 1.0;
        gridBagConstraints12.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints12.gridx = 1;
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.fill = 2;
        gridBagConstraints10.gridy = 1;
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints10.gridwidth = 3;
        gridBagConstraints10.gridx = 1;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.gridy = 0;
        gridBagConstraints9.weightx = 1.0;
        gridBagConstraints9.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints9.gridwidth = 3;
        gridBagConstraints9.gridx = 1;
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 2;
        gridBagConstraints8.anchor = 13;
        gridBagConstraints8.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints8.gridy = 2;
        this._costLabel = new JLabel();
        this._costLabel.setText("[Cost]");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.anchor = 13;
        gridBagConstraints7.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints7.gridy = 2;
        this._pagesLabel = new JLabel();
        this._pagesLabel.setText("[Pages]");
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.anchor = 13;
        gridBagConstraints6.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints6.gridy = 1;
        this._printerLabel = new JLabel();
        this._printerLabel.setText("[Printer Name]");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.anchor = 13;
        gridBagConstraints5.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints5.gridy = 0;
        this._documentNameLabel = new JLabel();
        this._documentNameLabel.setText("[Document Name]");
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, "[Print Details]", 0, 0, null, null));
        this.add((Component)this._documentNameLabel, gridBagConstraints5);
        this.add((Component)this._printerLabel, gridBagConstraints6);
        this.add((Component)this._pagesLabel, gridBagConstraints7);
        this.add((Component)this._costLabel, gridBagConstraints8);
        this.add((Component)this.getDocNameTextField(), gridBagConstraints9);
        this.add((Component)this.getPrinterNameTextField(), gridBagConstraints10);
        this.add((Component)this.getTotalPagesTextField(), gridBagConstraints12);
        this.add((Component)this.getCostTextField(), gridBagConstraints13);
    }

    public void removePagesAndCostDetails() {
        this.remove(this._pagesLabel);
        this.remove(this.getTotalPagesTextField());
        this.remove(this._costLabel);
        this.remove(this.getCostTextField());
    }

    private JTextField getDocNameTextField() {
        if (this._docNameTextField == null) {
            this._docNameTextField = new JTextField();
            this._docNameTextField.setEditable(false);
        }
        return this._docNameTextField;
    }

    private JTextField getPrinterNameTextField() {
        if (this._printerNameTextField == null) {
            this._printerNameTextField = new JTextField();
            this._printerNameTextField.setEditable(false);
        }
        return this._printerNameTextField;
    }

    private JTextField getTotalPagesTextField() {
        if (this._totalPagesTextField == null) {
            this._totalPagesTextField = new JTextField();
            this._totalPagesTextField.setEditable(false);
        }
        return this._totalPagesTextField;
    }

    private JTextField getCostTextField() {
        if (this._costTextField == null) {
            this._costTextField = new JTextField();
            this._costTextField.setEditable(false);
        }
        return this._costTextField;
    }

    private static String getMessage(String key, String ... args) {
        String fullKey = "SelectAccount." + key;
        return Messages.getString(UserClient.class, (String)fullKey, (String[])args);
    }
}

