/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.io.IOUtils;
import biz.papercut.pcng.util.io.LineHandler;
import biz.papercut.pcng.util.io.NullOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ProcessUtils {
    private static final Log logger = LogFactory.getLog(ProcessUtils.class);
    private static final OutputStream DEV_NULL = new NullOutputStream();

    private ProcessUtils() {
    }

    public static int exec(String[] cmdArray) throws IOException, InterruptedException {
        return ProcessUtils.exec(cmdArray, null, DEV_NULL, DEV_NULL);
    }

    public static int exec(String[] cmdArray, @Nullable InputStream stdin, @Nullable OutputStream stdout, @Nullable OutputStream stderr) throws IOException, InterruptedException {
        if (stdout == null) {
            stdout = DEV_NULL;
        }
        if (stderr == null) {
            stderr = DEV_NULL;
        }
        return ProcessUtils.exec(cmdArray, new DefaultStreamHandler(stdin, stdout, stderr));
    }

    public static int exec(String[] cmdArray, ProcessStreamHandler streamHandler) throws IOException, InterruptedException {
        return ProcessUtils.exec(cmdArray, streamHandler, null);
    }

    public static int exec(String[] cmdArray, ProcessStreamHandler streamHandler, String[] env) throws IOException, InterruptedException {
        return ProcessUtils.exec(cmdArray, streamHandler, env, null);
    }

    public static int exec(String[] cmdArray, ProcessStreamHandler streamHandler, String[] env, boolean[] hideArgsInLogs) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        Process proc = ProcessUtils.execProcess(cmdArray, streamHandler, env, hideArgsInLogs);
        int exitCode = proc.waitFor();
        long stop = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Exit code is " + exitCode + " and took " + (stop - start) + " ms running: " + cmdArray[0]));
        }
        streamHandler.stop();
        return exitCode;
    }

    public static int exec(String[] cmdArray, ProcessStreamHandler streamHandler, String[] env, int timeOutSec) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        Process proc = ProcessUtils.execProcess(cmdArray, streamHandler, env, null);
        boolean hasCompleted = false;
        int exitCode = -1;
        while (!hasCompleted) {
            Thread.sleep(500L);
            try {
                exitCode = proc.exitValue();
                hasCompleted = true;
            }
            catch (IllegalThreadStateException e) {
                if (System.currentTimeMillis() <= start + (long)(timeOutSec * 1000)) continue;
                logger.debug((Object)("Timeout exceeded executing " + cmdArray[0]));
                proc.destroy();
                throw new InterruptedException("Timeout exceeded.");
            }
        }
        long stop = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Exit code for '" + cmdArray[0] + "' is: " + exitCode + ". Took " + (stop - start) + " ms."));
        }
        streamHandler.stop();
        return exitCode;
    }

    private static Process execProcess(String[] cmdArray, ProcessStreamHandler streamHandler, String[] env, boolean[] hideArgsInLogs) throws IOException {
        if (cmdArray == null || cmdArray.length == 0) {
            throw new IllegalArgumentException("Exec command array is null or empty.");
        }
        if (streamHandler == null) {
            throw new IllegalArgumentException("Null stream handler");
        }
        if (logger.isDebugEnabled()) {
            Object[] debugCmdArray;
            if (hideArgsInLogs != null && hideArgsInLogs.length > 0) {
                debugCmdArray = (String[])cmdArray.clone();
                for (int i = 0; i < hideArgsInLogs.length; ++i) {
                    if (!hideArgsInLogs[i]) continue;
                    debugCmdArray[i] = "<hidden>";
                }
            } else {
                debugCmdArray = cmdArray;
            }
            logger.debug((Object)("Execute: " + StringUtils.join((Object[])debugCmdArray, (char)' ')));
        }
        Process proc = Runtime.getRuntime().exec(cmdArray, env);
        streamHandler.setProcessInputStream(proc.getOutputStream());
        streamHandler.setProcessErrorStream(proc.getErrorStream());
        streamHandler.setProcessOutputStream(proc.getInputStream());
        streamHandler.start();
        return proc;
    }

    public static String quoteArgument(String argument) {
        if (argument == null || argument.length() == 0) {
            return "\"\"";
        }
        return '\"' + argument + '\"';
    }

    public static interface ProcessStreamHandler {
        public void setProcessInputStream(OutputStream var1) throws IOException;

        public void setProcessErrorStream(InputStream var1) throws IOException;

        public void setProcessOutputStream(InputStream var1) throws IOException;

        public void start();

        public void stop();
    }

    public static class LineStreamHandler
    extends AbstractStreamHandler {
        @CheckForNull
        private Reader _stdin;
        private LineHandler _stdout;
        private LineHandler _stderr;
        private Charset _charset;

        public LineStreamHandler(@Nullable Reader stdin, LineHandler stdout, LineHandler stderr, Charset charset) {
            this._stdin = stdin;
            this._stdout = stdout;
            this._stderr = stderr;
            this._charset = charset;
        }

        public LineStreamHandler(Reader stdin, LineHandler stdout, LineHandler stderr) {
            this._stdin = stdin;
            this._stdout = stdout;
            this._stderr = stderr;
            this._charset = Charset.defaultCharset();
        }

        public void setProcessInputStream(OutputStream os) throws IOException {
            if (this._stdin != null) {
                this.setStdinThread(this.createReaderPump(this._stdin, new OutputStreamWriter(os, this._charset), true));
            }
        }

        public void setProcessErrorStream(InputStream is) throws IOException {
            this.setStderrThread(this.createLinePump(new InputStreamReader(is, this._charset), this._stderr, Thread.currentThread().getName() + " stderr"));
        }

        public void setProcessOutputStream(InputStream is) throws IOException {
            this.setStdoutThread(this.createLinePump(new InputStreamReader(is, this._charset), this._stdout, Thread.currentThread().getName() + " stdout"));
        }

        protected Thread createLinePump(final Reader inputReader, final LineHandler output, String pumpThreadName) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        BufferedReader reader = new BufferedReader(inputReader);
                        IOUtils.copyLines(reader, output);
                    }
                    catch (IOException e) {
                        logger.debug((Object)"Ignored error", (Throwable)e);
                    }
                }
            }, pumpThreadName);
            thread.setDaemon(true);
            return thread;
        }

        protected Thread createReaderPump(final Reader input, final Writer output, final boolean closeWhenExhausted) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        IOUtils.copy(input, output, closeWhenExhausted);
                    }
                    catch (IOException e) {
                        logger.debug((Object)"Ignored error", (Throwable)e);
                    }
                }
            }, Thread.currentThread().getName() + " stdin");
            thread.setDaemon(true);
            return thread;
        }
    }

    public static class DefaultStreamHandler
    extends AbstractStreamHandler {
        @CheckForNull
        private InputStream _stdin;
        private OutputStream _stdout;
        private OutputStream _stderr;

        public DefaultStreamHandler(@Nullable InputStream stdin, OutputStream stdout, OutputStream stderr) {
            this._stdin = stdin;
            this._stdout = stdout;
            this._stderr = stderr;
        }

        public void setProcessInputStream(OutputStream os) throws IOException {
            if (this._stdin != null) {
                this.setStdinThread(this.createStreamPump(this._stdin, os, true, Thread.currentThread().getName() + " stdin"));
            } else {
                try {
                    os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void setProcessErrorStream(InputStream is) throws IOException {
            this.setStderrThread(this.createStreamPump(is, this._stderr, false, Thread.currentThread().getName() + " stderr"));
        }

        public void setProcessOutputStream(InputStream is) throws IOException {
            this.setStdoutThread(this.createStreamPump(is, this._stdout, false, Thread.currentThread().getName() + " stdout"));
        }

        protected Thread createStreamPump(final InputStream is, final OutputStream os, final boolean closeWhenExhausted, String pumpThreadName) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        IOUtils.copy(is, os, closeWhenExhausted);
                    }
                    catch (IOException e) {
                        logger.debug((Object)"Ignored error", (Throwable)e);
                    }
                }
            }, pumpThreadName);
            thread.setDaemon(true);
            return thread;
        }
    }

    public static abstract class AbstractStreamHandler
    implements ProcessStreamHandler {
        @Nullable
        private Thread _stdoutThread;
        @Nullable
        private Thread _stderrThread;
        @CheckForNull
        private Thread _stdinThread;

        public void start() {
            if (this._stdinThread != null) {
                this._stdinThread.start();
            }
            this._stdoutThread.start();
            this._stderrThread.start();
        }

        public void stop() {
            if (this._stdinThread != null) {
                try {
                    this._stdinThread.join();
                }
                catch (InterruptedException e) {
                    logger.debug((Object)"Ignored error", (Throwable)e);
                }
            }
            try {
                this._stdoutThread.join();
            }
            catch (InterruptedException e) {
                logger.debug((Object)"Ignored error", (Throwable)e);
            }
            try {
                this._stderrThread.join();
            }
            catch (InterruptedException e) {
                logger.debug((Object)"Ignored error", (Throwable)e);
            }
        }

        public Thread getStderrThread() {
            return this._stderrThread;
        }

        public void setStderrThread(Thread stderrThread) {
            this._stderrThread = stderrThread;
        }

        @CheckForNull
        public Thread getStdinThread() {
            return this._stdinThread;
        }

        public void setStdinThread(Thread stdinThread) {
            this._stdinThread = stdinThread;
        }

        public Thread getStdoutThread() {
            return this._stdoutThread;
        }

        public void setStdoutThread(Thread stdoutThread) {
            this._stdoutThread = stdoutThread;
        }
    }
}

